@echo off
setlocal

set "SRC=%~dp0TGFB_QOL_Hook.lua"

if not exist "%SRC%" (
  echo ERROR: TGFB_QOL_Hook.lua not found next to this installer.
  pause
  exit /b 1
)

set "SAVED=%USERPROFILE%\Saved Games"

set "TARGET1=%SAVED%\DCS\Scripts\Hooks"

set "OPENBETA_ROOT=%SAVED%\DCS.openbeta"
set "TARGET2=%OPENBETA_ROOT%\Scripts\Hooks"

echo Installing TGFB_QOL_Hook.lua...
echo Source: "%SRC%"

set "COPIED=0"

if not exist "%TARGET1%" (
  echo Creating "%TARGET1%"...
  mkdir "%TARGET1%" 2>nul
  if errorlevel 1 (
    echo ERROR: Failed to create "%TARGET1%".
    pause
    exit /b 2
  )
)

echo Copying to "%TARGET1%"...
copy /Y "%SRC%" "%TARGET1%\" >nul
if errorlevel 1 (
  echo ERROR: Failed to copy to "%TARGET1%".
  pause
  exit /b 3
) else (
  echo OK: Copied to "%TARGET1%".
  set "COPIED=1"
)

if exist "%OPENBETA_ROOT%\" (
  if not exist "%TARGET2%" (
    echo Creating "%TARGET2%"...
    mkdir "%TARGET2%" 2>nul
    if errorlevel 1 (
      echo WARNING: Failed to create "%TARGET2%". Skipping openbeta copy.
      goto check_process
    )
  )
  echo Copying to "%TARGET2%"...
  copy /Y "%SRC%" "%TARGET2%\" >nul
  if errorlevel 1 (
    echo WARNING: Failed to copy to "%TARGET2%".
  ) else (
    echo OK: Copied to "%TARGET2%".
    set "COPIED=1"
  )
) else (
  echo Note: Openbeta folder not found at "%OPENBETA_ROOT%". Skipping openbeta.
)

:check_process
if "%COPIED%"=="0" (
  echo.
  echo ERROR: Failed to copy any files. Please attempt to manually install the file.
  pause
  exit /b 0
)

echo.
tasklist /FI "IMAGENAME eq DCS.exe" 2>nul | find /I "DCS.exe" >nul
if errorlevel 1 (
  echo Installation finished.
  pause
  exit /b 0
)

echo DCS.exe appears to be running.
echo Please restart DCS for changes to take effect!
echo Installation finished.
pause
exit /b 0